<?php
// admin-login.php - Handles admin authentication
// Validates credentials and returns JWT token

require_once __DIR__ . '/config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Only POST requests are allowed', 405);
}

try {
    $data = getRequestData();
    
    if (!$data) {
        sendError('No data received', 400);
    }
    
    // Validate required fields
    if (!isset($data['username']) || !isset($data['password'])) {
        sendError('Username and password are required', 400);
    }
    
    $username = trim($data['username']);
    $password = trim($data['password']);
    
    // Simple hardcoded credentials (in production, use database)
    $validCredentials = [
        'admin' => 'SheyDoc2025!',
        'sheydoc' => 'AdminPass123!',
        'superadmin' => 'SuperAdmin2025!'
    ];
    
    // Check credentials
    if (!isset($validCredentials[$username]) || $validCredentials[$username] !== $password) {
        sendError('Invalid username or password', 401);
    }
    
    // Generate a simple token (in production, use proper JWT)
    $token = 'SheySuperAdmin2025';
    
    // Return success response
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'token' => $token,
        'user' => [
            'username' => $username,
            'role' => 'admin'
        ],
        'message' => 'Login successful'
    ]);
    exit();
    
} catch (Exception $e) {
    sendError('Login failed: ' . $e->getMessage(), 500);
} finally {
    $database->closeConnection();
}
?>
