<?php
// book-click.php - Track booking button clicks for analytics
// Records clicks on the "Book Doctor" button

require_once __DIR__ . '/config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendError('Only POST requests are allowed', 405);
}

try {
    // Get request data
    $data = getRequestData();
    
    if (!$data) {
        sendError('No data received', 400);
    }
    
    // Validate required fields
    if (!isset($data['doctor_id']) || !is_numeric($data['doctor_id'])) {
        sendError('Valid doctor_id is required', 400);
    }
    
    $doctorId = (int)$data['doctor_id'];
    
    // Insert click record
    $query = "INSERT INTO booking_clicks (doctor_id, click_date) VALUES (?, NOW())";
    $stmt = $db->prepare($query);
    
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $db->error);
    }
    
    $stmt->bind_param("i", $doctorId);
    
    if ($stmt->execute()) {
        http_response_code(200);
        echo json_encode([
            'success' => true,
            'message' => 'Click recorded successfully'
        ]);
    } else {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $stmt->close();
    
} catch (Exception $e) {
    sendError('Failed to record click: ' . $e->getMessage(), 500);
} finally {
    $database->closeConnection();
}
?>
