<?php
// config.php - Main configuration file for api.sheydoc.com
// Contains CORS headers and database connection

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set CORS headers for Vercel frontend
header("Access-Control-Allow-Origin: https://www.sheydoc.com");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");
header('Content-Type: application/json');

// Handle preflight OPTIONS requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'healixnj_sheydoc');
define('DB_USER', 'healixnj');
define('DB_PASS', 'T8XIjwU19m91');

// API configuration
define('API_VERSION', '1.0');
define('API_BASE_URL', 'https://api.sheydoc.com');

// Utility functions
function sendResponse($data, $statusCode = 200) {
    http_response_code($statusCode);
    echo json_encode([
        'success' => true,
        'data' => $data,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    exit();
}

function sendError($message, $statusCode = 400) {
    http_response_code($statusCode);
    echo json_encode([
        'success' => false,
        'error' => $message,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    exit();
}

function validateAdminToken($token) {
    $validToken = 'SheySuperAdmin2025';
    return $token === $validToken;
}

function getRequestData() {
    $input = file_get_contents('php://input');
    return json_decode($input, true);
}

// Include database connection
require_once __DIR__ . '/db_connect.php';
?>
