<?php
// fix-image-urls.php - Fix image URLs in database to use production URLs
// This script updates all localhost image URLs to use the production API URL

require_once __DIR__ . '/config.php';

try {
    echo "<h2>Fixing Image URLs in Database</h2>";
    
    // Get all doctors with localhost image URLs
    $query = "SELECT id, photoUrl FROM doctors WHERE photoUrl LIKE '%localhost%'";
    $result = $db->query($query);
    
    if (!$result) {
        throw new Exception("Query failed: " . $db->error);
    }
    
    $updated = 0;
    while ($row = $result->fetch_assoc()) {
        $oldUrl = $row['photoUrl'];
        $filename = basename($oldUrl);
        $newUrl = 'https://api.sheydoc.com/uploads/doctors/' . $filename;
        
        // Update the URL
        $updateQuery = "UPDATE doctors SET photoUrl = ? WHERE id = ?";
        $stmt = $db->prepare($updateQuery);
        $stmt->bind_param("si", $newUrl, $row['id']);
        
        if ($stmt->execute()) {
            echo "Updated doctor ID {$row['id']}: {$oldUrl} → {$newUrl}<br>";
            $updated++;
        } else {
            echo "Failed to update doctor ID {$row['id']}<br>";
        }
        
        $stmt->close();
    }
    
    echo "<h3>Summary</h3>";
    echo "Updated {$updated} doctor image URLs<br>";
    
    if ($updated === 0) {
        echo "No localhost URLs found to update.<br>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "<br>";
} finally {
    $database->closeConnection();
}
?>
