<?php
// test.php - Simple API test endpoint
// Returns a basic JSON response to verify API connectivity

require_once __DIR__ . '/config.php';

try {
    // Test database connection
    $testQuery = "SELECT 1 as test";
    $result = $db->query($testQuery);
    
    if ($result) {
        sendResponse([
            'message' => 'API is working correctly!',
            'database' => 'Connected successfully',
            'server_time' => date('Y-m-d H:i:s'),
            'api_version' => API_VERSION,
            'endpoints' => [
                'GET /test.php' => 'This test endpoint',
                'GET /get_users.php' => 'Get dummy user data',
                'POST /save_data.php' => 'Save data to database'
            ]
        ]);
    } else {
        sendError('Database connection test failed', 500);
    }
    
} catch (Exception $e) {
    sendError('API test failed: ' . $e->getMessage(), 500);
} finally {
    $database->closeConnection();
}
?>
